<?php
namespace VM\ApiBundle\Services;

use Doctrine\ORM\EntityManager;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\Request;

class SSOMethods
{
    /**
     * @var EntityManager
     */
    protected $EntityManager;

    /**
     * @var ContainerInterface
     */
    protected $Container;

    protected $curlRequest;

    protected $curlOptions;

    protected $ssoUrlLogin;
    protected $ssoAppKey;


    public function __construct(EntityManager $EntityManager, ContainerInterface $Container, $SsoUrlLogin, $SsoAppKey)
    {
        $this->EntityManager = $EntityManager;
        $this->Container = $Container;
        $this->ssoUrlLogin = $SsoUrlLogin;
        $this->ssoAppKey = $SsoAppKey;
    }

    public function getResponse()
    {
        $responseString = curl_exec($this->curlRequest);
        $request = $this->validateResponse($responseString);
        return $request;
    }

    public function setOptions($method, $params)
    {
        $this->initConnection();
        $postParams = array(
            'params' => $params,
            'appKey' => $this->ssoAppKey,
            'method' => $method,
        );

//        $params = array(
//            'params' => array(
//                'email' => 'test@vm.pl',
//                'password' => '123456',
//                'name' => 'Test',
//                'surname' => 'Testowy',
//            ),
//            'appKey' => $this->ssoAppKey,
//            'method' => 'user_register',
//        );

//        $params = array(
//            'params' => array(
//                'user_id' => 1,
//                'confirmation_token' => 'rWLqDiJuLUJIj40EMPoAaeF36usnOFVWsauLQj4B8dw',
//            ),
//            'appKey' => $this->ssoAppKey,
//            'method' => 'user_registration_confirm',
//        );

        $options = array(
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_HTTPHEADER => array('Content-type: application/json') ,
            CURLOPT_POSTFIELDS => json_encode($postParams)
        );

        curl_setopt_array($this->curlRequest, $options);
    }

    protected function initConnection()
    {
        $this->curlRequest = curl_init($this->ssoUrlLogin);
    }

    protected function validateResponse($responseString)
    {
        $info = curl_getinfo($this->curlRequest);
        if($info['http_code'] != 200)
        {
            throw new \Exception('response is empty', 404);
        }

        $error = curl_error($this->curlRequest);
        if(!empty($error))
        {
            throw new \Exception($error, 1010);
        }

        if(empty($responseString))
        {
            throw new \Exception('response is empty', 1000);
        }

        return json_decode($responseString, true);
    }
}